import {
    View,
    Text,
    ScrollView,
    Image,
    TouchableOpacity,
    TextInput,
    Pressable,
} from "react-native";
import React, { useEffect, useState } from "react";
import BackNavigation from "../../../../../Utilities/CustomHeader/BackNavigation";
import { writeReviewStyle } from "./WriteReviewsStyle";
import CommonStyles from "../../../../../Utilities/CommonStyles/CommonStyles";
import dpr from "../../../../../Utilities/CustomStyleAttribute/dpr";
import UploadIcon from "../../../../../../assets/svgs/reviews/upload-photo-icon.svg";
import { editReviewStyle } from "../../../../../Profile/EditReview/EditReview";
import PlusIcon from "../../../../../../assets/svgs/cart/plus.svg";
import useAuth from "../../../../../../hooks/useAuth";
import { useDispatch, useSelector } from "react-redux";
import { postReview } from "../../../../../../redux/slices/featureProducts/reviews/postReviews";
import CustomSpinner from "../../../../../Utilities/CustomSpinner/CustomSpinner";
import usePreferences from "../../../../../../hooks/usePreferences";
import useCustomToast from "../../../../../../hooks/useCustomToast";
import { BASE_API_URL_STG } from "@env";
import CustomRating from "../../../../../Utilities/CustomRating/CustomRating";
import useUploadMultipleFile from "../../../../../../hooks/useUploadMultipleFile";
import { round } from "../../../../../../helper/ratingRound";
import useLangTranslation from "../../../../../../hooks/useLangTranslation";
import { query } from "../../../../../../redux/slices/util/apiRequest";
import { getPreferences } from "../../../../../../redux/slices/preferences/getPreferences";
import { queryResponse } from "../../../../../../redux/slices/util/processResponse";
import CustomSVG from "../../../../../../src/components/CustomSVG/CustomSVG";

let URL = `${BASE_API_URL_STG}/user/review/store`;
const WriteReviews = (props) => {
    const { trans } = useLangTranslation();
    const { product_general: { rating_required, rating_enable } = {} } =
        usePreferences();
    const { access_token } = useAuth();
    const dispatch = useDispatch();
    const showToast = useCustomToast();
    const {
        reviews,
        productDetails,
        setProductDetails,
        setCanReview,
        avgRating,
        setMoreReviews,
        setNextPageUrl,
        setReviews
    } = props?.route?.params;
    let { loading } = useSelector((state) => state.postReview);
    const { id, slug, name, featured_image } = productDetails;
    const url = `${BASE_API_URL_STG}/user/reviews/${id}`;
    const productDetailsUrl = `${BASE_API_URL_STG}/user/product/${slug}`;
    let maxLength = 500;

    const [text, setText] = useState("");
    const [stars, setStars] = useState(0);
    const [images, setImages] = useState([]);
    const reviewData = {};
    const uploadImage = useUploadMultipleFile();
    const handleUploadImages = async () => {
        try {
            const result = await uploadImage();
            if (result) {
                setImages([...images, ...result]);
            }
        } catch (e) {}
    };

    const ratingCompleted = (rating) => {
        setStars(round(rating));
    };
    const storeReviewData = async () => {
        reviewData.rating = stars;
        reviewData.images = images;
        reviewData.comments = text;
        let formData = new FormData();
        formData.append("product_id", id);
        formData.append("comments", reviewData.comments);
        formData.append("rating", reviewData.rating);
        for (let item of images) {
            formData.append("image[]", item);
        }

        if (rating_required == 1 && !stars) {
            showToast({
                text1: trans("Rating field is required"),
                type: "common",
                position: "bottom",
                props: { variant: "info" },
            });
            return;
        }

        try {
            let newReview = await dispatch(
                postReview({
                    access_token,
                    URL,
                    method: "POST",
                    formData,
                })
            );
            let { code } = newReview?.payload?.status;
            let { message } = newReview?.payload?.records;

            if (code == 200) {
                showToast({
                    text1: trans(message),
                    type: "common",
                    position: "bottom",
                    props: { variant: "success" },
                });
                
                dispatch(getPreferences());
                let singleItem = await query(
                    productDetailsUrl,
                    "GET",
                    access_token
                );
                if (singleItem?.data?.id) {
                    setCanReview(singleItem?.data?.can_review);
                    setProductDetails(singleItem);
                }
                props.navigation.goBack();
                const res = await queryResponse(url, 'GET');
                const { records, status: { code: statusCode } = {} } = res || {};
                const { data, pagination } = records || {};
                if (statusCode == 200) {
                    setReviews(data)
                    setMoreReviews(data)
                    setNextPageUrl(pagination?.next_page_url)
                }
                loading = false;
            } else {
                showToast({
                    text1: trans(message),
                    type: "common",
                    position: "bottom",
                    props: { variant: "error" },
                });
                loading = false;
                props.navigation.goBack();
            }
        } catch (error) {
            showToast({
                text1: trans("Review submit unsuccessful. Please try again!"),
                type: "common",
                position: "bottom",
                props: { variant: "error" },
            });
        }
    };

    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans("Write a Review")}
                capitalize={true}
            />
            <ScrollView
                showsVerticalScrollIndicator={false}
                style={CommonStyles.cont}
            >
                <View style={CommonStyles.globalContainer}>
                    <View style={writeReviewStyle.imgRatingCon}>
                        <View style={writeReviewStyle.imgCon}>
                            {featured_image && <Image
                                source={{ uri: featured_image }}
                                style={writeReviewStyle.productImg}
                            />}
                        </View>
                        <View>
                            <Text style={writeReviewStyle.productName}>
                                {name}
                            </Text>
                            <View style={writeReviewStyle.ratingCon}>
                                <View>
                                    <CustomRating
                                        starSize={dpr(17)}
                                        rating={avgRating ? avgRating : 0}
                                        readOnly={true}
                                    />
                                </View>
                                <View>
                                    <Text style={writeReviewStyle.ratingCount}>
                                        {avgRating ? avgRating.toFixed(1) : 0} (
                                        {reviews?.length ? reviews?.length : 0})
                                    </Text>
                                </View>
                            </View>
                        </View>
                    </View>
                    {rating_enable == 1 && (
                        <View style={writeReviewStyle.addRatingsCon}>
                            <Text style={writeReviewStyle.addRatingText}>
                                {trans("Add Your Ratings")}
                            </Text>
                            <View style={writeReviewStyle.addRatingCon}>
                                <View>
                                    <CustomRating
                                        starSize={dpr(30)}
                                        rating={stars}
                                        onChange={ratingCompleted}
                                        starStyle={writeReviewStyle.starStyle}
                                    />
                                </View>
                                <View>
                                    <Text style={writeReviewStyle.ratingText}>
                                        {trans("{{x}} Stars", { x: stars })}
                                    </Text>
                                </View>
                            </View>
                        </View>
                    )}
                    <View style={writeReviewStyle.addRatingsCon}>
                        <Text style={writeReviewStyle.addRatingText}>
                            {trans("Add Photos")}
                        </Text>

                        <View>
                            <View>
                                {images.length == 0 && (
                                    <TouchableOpacity
                                        style={writeReviewStyle.uploadPhotos}
                                        onPress={handleUploadImages}
                                    >
                                        <View>
                                            <CustomSVG svgIcon={UploadIcon}
                                                width={dpr(35)}
                                                height={dpr(31)}
                                            />
                                        </View>
                                        <View>
                                            <Text
                                                style={
                                                    writeReviewStyle.uploadText
                                                }
                                            >
                                                {trans("Click here to upload photos")}
                                            </Text>
                                        </View>
                                    </TouchableOpacity>
                                )}
                                {images.length > 0 && (
                                    <View style={editReviewStyle.imgContainer}>
                                        {images.map((img, i) => {
                                            return (
                                                <View key={i}>
                                                    {img?.uri && <Image
                                                        style={
                                                            editReviewStyle.imgStyle
                                                        }
                                                        source={{
                                                            uri: img?.uri,
                                                        }}
                                                    />}
                                                </View>
                                            );
                                        })}
                                        <TouchableOpacity
                                            onPress={handleUploadImages}
                                        >
                                            <View
                                                style={
                                                    editReviewStyle.addPhotosCon
                                                }
                                            >
                                                <CustomSVG svgIcon={PlusIcon}
                                                    height={dpr(16)}
                                                    width={dpr(16)}
                                                    fill={"#c4c4c4"}
                                                />
                                            </View>
                                        </TouchableOpacity>
                                    </View>
                                )}
                            </View>
                        </View>
                    </View>
                    <View style={writeReviewStyle.addRatingsCon}>
                        <Text style={writeReviewStyle.addRatingText}>
                            {trans("Write Your Experience")}
                        </Text>
                        <View>
                            <TextInput
                                style={writeReviewStyle.textInputStyle}
                                multiline
                                numberOfLines={8}
                                maxLength={maxLength}
                                onChangeText={(newText) => setText(newText)}
                                placeholder={
                                    trans("What would you like to write about your experience with this product?")
                                }
                            ></TextInput>
                        </View>
                        <Text style={writeReviewStyle.remainingChar}>
                            {trans("{{x}} characters remaining", {
                                x: maxLength - text.length,
                            })}
                        </Text>
                    </View>
                </View>
            </ScrollView>
            <Pressable onPress={!loading ? storeReviewData : null}>
                <View style={writeReviewStyle.submitReview}>
                    <View style={writeReviewStyle.submitReviewCon}>
                        {loading ? (
                            <CustomSpinner
                                filePath={require("../../../../../../assets/lottie/loader2.json")}
                                size={{
                                    width: dpr(60),
                                    height: dpr(55),
                                }}
                            />
                        ) : (
                            <Text style={writeReviewStyle.submitReviewText}>
                                {trans("Submit Review")}
                            </Text>
                        )}
                    </View>
                </View>
            </Pressable>
        </>
    );
};

export default WriteReviews;
